﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using BMS.VistaIntegration.Mdws2.QuerySvcService;
using BMS.Utils;


namespace BMS.VistaIntegration.Mdws2.Abstract
{
    class SingleFileFetch<T> where T : class , new()
    {
        public FileMap<T> FileMap { get; private set; }


        private class ResultMaker : ISingleResultMaker
        {
            public T Result { get; private set; }
            private readonly FileMap<T> fileMap;
            private readonly QuerySvcSoap client;

            public ResultMaker(SingleFileFetch<T> fileFetch)
            {
                this.fileMap = fileFetch.FileMap;
                this.client = fileFetch.Client;

            }

            public void SetIen(string ien)
            {
                Result = fileMap.Make();
                fileMap.SetIen(Result, ien);
            }


            public void SetMultipleField(string subFileNumber, string fieldIen, string value)
            {
                fileMap.SetMultipleField(Result, subFileNumber, fieldIen, value);
            }


            public void SetField(string fieldIen, string value)
            {
                fileMap.SetField(Result, fieldIen, value);
                var reference = fileMap.GetReference(fieldIen);
                if (reference != null)
                    reference.SetFields(client, Result, value);
            }
        }

        private string GetFieldsParam()
        {
            return FileMap.FieldsParam + FileMap.MultipleFieldsParam;
        }

        private string fieldsParam;

        public SingleFileFetch(FileMap<T> fileMap)
        {
            this.FileMap = fileMap;
            fieldsParam = GetFieldsParam();
        }

        public QuerySvcSoap Client { get; set; }
        public string Ien { get; set; }

        public T GetResult()
        {

            GetFetchCommand command = new GetFetchCommand(Client);
            command.FileParam = FileMap.FileNumber;
            command.FieldParam = GetFieldsParam();
            command.IenParam = Ien;
            ResultMaker maker = new ResultMaker(this);
            command.Execute(maker);
            return maker.Result;

        }


    }
}
